#pragma once
#include "graph.h"

namespace NCrypta::NGraphEngine {
    class THumanMatchingTypes {
    public:
        THumanMatchingTypes();

        bool IsAvailable(const NCrypta::NSoup::TEdgeType& type) const;
        bool IsAvailable(const EIdType& type1, const EIdType& type2) const;
        const TSet<EIdType>& GetAdjacentTypes(const EIdType& type) const;

    private:
        TMap<EIdType, TSet<EIdType>> Neighbours{};
        const TSet<EIdType> Empty{};

        void Init();
    };

    class THMGraphGenerator {
    public:
        NCrypta::NGraphEngine::TCommonGraph GenerateGraph(ui64 size, double connectivityRate = 0.5);

    private:
        NCrypta::NGraphEngine::NCustomView::TVertex ChooseRandomVertex(const NCrypta::NGraphEngine::TCommonGraph& graph);
        NCrypta::NGraphEngine::NCustomView::TVertex GenerateVertex(const EIdType& type);
    };

}
