#pragma once
#include "graph.h"

namespace NCrypta::NGraphEngine {

    struct TCustomSplit {
        TVector<TVector<NCustomView::TVertex>> Split;
    };

    struct TDijkstraSetElement {
        double distance;
        ui64 vertexIndex;
        ui64 parentVertexIndex;
        bool operator<(const TDijkstraSetElement& other) const {
            return std::tie(distance, vertexIndex, parentVertexIndex) < std::tie(other.distance, other.vertexIndex, other.parentVertexIndex);
        }
        bool operator==(const TDijkstraSetElement& other) const {
            return std::fabs(distance - other.distance) <= std::numeric_limits<double>::epsilon() && vertexIndex == other.vertexIndex && parentVertexIndex == other.parentVertexIndex;
        }
    };

    TCustomSplit Split(const TCommonGraph& graph);

    TVector<ui64> ConvertComponentsToSplit(const int size, const TDisjointSets& components);

    void JoinSmallComponentsBetweenBigComponents(const NInnerView::TGraph& graph, TDisjointSets& components, const ui64 minSingleSize = 3);

    TVector<ui64> Split(const NInnerView::TGraph& graph);
}
