#include <library/cpp/testing/unittest/registar.h>
#include <crypta/lib/native/identifiers/lib/generic.h>
#include <crypta/graph/engine/graph/lib/algo.h>



Y_UNIT_TEST_SUITE(TUnitAlgoTest) {

    using NCrypta::NGraphEngine::TCommonGraph;


    TCommonGraph GenerateTwoConnectedTriangles() {
        TCommonGraph graph;
        graph.AddEdges({
               {
                       {EIdType::YANDEXUID, "1"},
                       {EIdType::YANDEXUID, "2"}
               },
               {
                       {EIdType::YANDEXUID, "2"},
                       {EIdType::YANDEXUID, "3"}
               },
               {
                       {EIdType::YANDEXUID, "3"},
                       {EIdType::YANDEXUID, "1"}
               },
               {
                       {EIdType::YANDEXUID, "3"},
                       {EIdType::YANDEXUID, "4"}
               },
               {
                       {EIdType::YANDEXUID, "4"},
                       {EIdType::YANDEXUID, "5"}
               },
               {
                       {EIdType::YANDEXUID, "5"},
                       {EIdType::YANDEXUID, "6"}
               },
               {
                       {EIdType::YANDEXUID, "6"},
                       {EIdType::YANDEXUID, "4"}
               }
        });
        return graph;
    }


    Y_UNIT_TEST(TAlgoSimpleTest) {
        auto graph = GenerateTwoConnectedTriangles();

        const auto bridges = NCrypta::NGraphEngine::NAlgo::FindBridges(graph);

        UNIT_ASSERT_EQUAL(bridges.size(), 1);
        auto bridge = bridges.front();
        NCrypta::NGraphEngine::NCustomView::TEdge expectedBridge{
                {EIdType::YANDEXUID, "3"},
                {EIdType::YANDEXUID, "4"}
        };
        UNIT_ASSERT_EQUAL(bridge, expectedBridge);
    }

    Y_UNIT_TEST(TAlgoClustringCoefficientTest) {
        auto graph = GenerateTwoConnectedTriangles();
        graph.AddEdge({
                              {EIdType::YANDEXUID, "6"},
                              {EIdType::YANDEXUID, "7"}
                      });
        auto cc = NCrypta::NGraphEngine::NAlgo::ComputeClusteringCoefficient(graph);
        UNIT_ASSERT_EQUAL(cc.GetTrianglesCount(), 2);
        UNIT_ASSERT_EQUAL(cc.GetConnectedTripletsCount(), 8);
        UNIT_ASSERT_EQUAL(cc.GetClusteringCoefficient(), 0.25);
    }
}
