#pragma once
#include <mapreduce/yt/common/config.h>
#include <mapreduce/yt/interface/client.h>
#include <mapreduce/yt/interface/operation.h>
#include <mapreduce/yt/util/ypath_join.h>
#include <crypta/lib/native/yt/utils/helpers.h>
#include <crypta/graph/engine/graph/run/proto/st.pb.h>
#include <crypta/graph/engine/graph/lib/algo.h>
#include <mapreduce/yt/interface/common.h>
#include <library/cpp/protobuf/yql/descriptor.h>

namespace NOp {
        using NCrypta::NGraphEngine::TCommonGraph;
        using NCrypta::NGraphEngine::TGraphStats;
        using NCrypta::NGraphEngine::TProtoComponent;


        class TCalculateStatsMapper : public NYT::IMapper<NYT::TTableReader<TProtoComponent>, NYT::TTableWriter<TGraphStats>> {
        public :

            void Do(NYT::TTableReader <TProtoComponent> *input, NYT::TTableWriter <TGraphStats> *output)
            override
            {
                auto& row = input->GetRow();
                NCrypta::NGraphEngine::TCommonGraph graph(row.GetGraph());
                TGraphStats stats = NCrypta::NGraphEngine::NAlgo::ComputeGraphStats(graph);
                stats.SetCryptaId(row.GetCryptaId());
                output->AddRow(stats);
            }
        };


        void CollectStats(NYT::IClientPtr& client) {
            NYT::TMapOperationSpec spec;
            spec.AddInput<TProtoComponent>(
                    "//home/crypta/production/state/graph/v2/matching/components_by_crypta_id");
            TString destination("//home/crypta/team/atanna/graph/cc");
            const auto schema = NYT::CreateTableSchema<NCrypta::NGraphEngine::TGraphStats>();
            spec.AddOutput<TGraphStats>(NYT::TRichYPath(destination).Schema(schema));
            NYT::TOperationOptions options;
            client->Map(spec, new NOp::TCalculateStatsMapper, options);


            client->Sort(NYT::TSortOperationSpec()
                                 .AddInput(destination)
                                 .Output(destination)
                                 .SortBy({"CryptaId"}));


            NCrypta::SetYqlProtoFields<TGraphStats>(client, destination);
        }
}

REGISTER_MAPPER(NOp::TCalculateStatsMapper);
