#pragma once

#include <util/generic/yexception.h>
#include <util/stream/mem.h>
#include <jni.h>
#include <google/protobuf/message.h>


namespace NJNI {
    void Rethrow(JNIEnv* env) {
        env->ExceptionClear();
        try {
            throw;
        } catch (const std::exception& e) {
            jclass jc = env->FindClass("java/lang/RuntimeException");
            if (jc) {
                env->ThrowNew(jc, e.what());
            }
        } catch (...) {
            jclass jc = env->FindClass("java/lang/RuntimeException");
            if (jc) {
                env->ThrowNew(jc, "Unhandled exception");
            }
        }
    }

    void FillProtoFromJByteArray(JNIEnv* env, const jbyteArray& data, NProtoBuf::Message& proto) {
        proto.Clear();
        jboolean isCopy;
        jint length = env->GetArrayLength(data);
        jbyte* buf = env->GetByteArrayElements(data, &isCopy);
        TString dataString(reinterpret_cast<char const*>(buf), length);
        Y_PROTOBUF_SUPPRESS_NODISCARD proto.ParseFromString(dataString);
        env->ReleaseByteArrayElements(data, buf, JNI_ABORT);
    }

    class TJniByteArrayHolder {
    public:
        TJniByteArrayHolder(JNIEnv* env, const TString& data)
            : Env(env)
            , Array(nullptr)
        {
            Array = Env->NewByteArray(data.size());
            if (!data.empty()) {
                Env->SetByteArrayRegion(Array, 0, data.size(), reinterpret_cast<const jbyte*>(data.c_str()));
            }
        }

        ~TJniByteArrayHolder() {
            if (Array) {
                Env->DeleteLocalRef(Array);
                Array = nullptr;
            }
        }

        jbyteArray Get() const {
            return Array;
        }

    private:
        JNIEnv* Env;
        jbyteArray Array;
    };
}
