package ru.yandex.crypta.graph.engine.score.stats;

import ru.yandex.crypta.graph.engine.proto.TGraph;
import ru.yandex.crypta.graph.engine.proto.TStats;
import ru.yandex.crypta.graph.engine.proto.TStatsOptions;

public class EngineHelper {
    static {
        System.loadLibrary("engine_java");
    }

    native public static TStats collectExpStats(byte[] graph, byte[] options);

    native public static TStats collectProdStats(byte[] graph, byte[] options);

    native public static String getYQlProtoFieldForStatsRecord();

    public static TStats collectExpStats(TGraph graph, TStatsOptions options) {
        return collectExpStats(graph.toByteArray(), options.toByteArray());
    }

    public static TStats collectProdStats(TGraph graph, TStatsOptions options) {
        return collectProdStats(graph.toByteArray(), options.toByteArray());
    }
}
