#include "score.h"

namespace NCrypta {
    namespace NGraphEngine {
        void TScoreBase::ToProto(TScore* score) const {
            score->SetName(Name);
            score->SetValue(Score * Weight);
        }

        TScore TScoreBase::ToProto() const {
            TScore score;
            ToProto(&score);
            return score;
        }

        void TScores::Add(const TScoreBase& score) {
            Scores.push_back(score);
        }

        double TScores::GetGeneralScore() const {
            return GetNormalizedWeightedScore();
        }

        double TScores::GetNormalizedWeightedScore() const {
            double generalScore = 0.;
            double generalWeight = 0.;
            for (const auto& score : Scores) {
                generalScore += score.Score * score.Weight;
                generalWeight += score.Weight;
            }
            if (generalWeight == 0) {
                return 0.;
            }
            generalScore /= generalWeight;
            return generalScore;
        }

        double TScores::GetWeightedScore() const {
            double generalScore = 0.;
            for (const auto& score : Scores) {
                generalScore += score.Score * score.Weight;
            }
            return generalScore;
        }

        TStats TScores::ToProto(ui64 id, double generalScore) const {
            TStats stats;
            stats.SetId(id);
            for (const auto& score : Scores) {
                score.ToProto(stats.add_scores());
            }
            stats.SetGeneralScore(generalScore);
            return stats;
        }

        TStats TScores::ToProto(ui64 id) const {
            return ToProto(id, GetGeneralScore());
        }

        TVector<TScoreBase> TScores::GetScoreList() const {
            return Scores;
        }
    }
}
