#pragma once

#include <iostream>
#include <util/generic/vector.h>
#include <crypta/graph/engine/proto/graph.pb.h>
#include <crypta/graph/engine/score/proto/stats.pb.h>

namespace NCrypta {
    namespace NGraphEngine {
        struct TScoreBase {
            TString Name{};
            double Score = 1.;
            double Weight = 1.;

            void ToProto(TScore* score) const;
            TScore ToProto() const;
        };

        class TScores {
        public:
            TScores() = default;
            explicit TScores(const TVector<TScoreBase>& scores)
                : Scores(scores) {}

            void Add(const TScoreBase& score);
            double GetGeneralScore() const;
            double GetNormalizedWeightedScore() const;
            double GetWeightedScore() const;
            TStats ToProto(ui64 id, double generalScore) const;
            TStats ToProto(ui64 id) const;
            TVector<TScoreBase> GetScoreList() const;
        private:
            TVector<TScoreBase> Scores{};
        };
    }
}
