#include "strategy.h"

namespace NCrypta {
    namespace NGraphEngine {

        double TAbstractScoringStrategy::ComputeWeight(const TGraph& /*graph*/) const {
            return DefaultWeight;
        }

        TScoreBase TAbstractScoringStrategy::ComputeScoreBase(const TGraph& graph) const {
            return {
                .Name = Name,
                .Score = ComputeScore(graph),
                .Weight = ComputeWeight(graph)};
        }

        TString TAbstractScoringStrategy::GetName() const {
            return Name;
        }

        void TMultiScoringStrategy::Add(THolder<TAbstractScoringStrategy> strategyPtr) {
            Strategies.emplace_back(std::move(strategyPtr));
        }

        TScores TMultiScoringStrategy::ComputeGraphScores(const TGraph& graph) const {
            TScores scores;
            for (const auto& strategy : Strategies) {
                scores.Add(strategy->ComputeScoreBase(graph));
            }
            return scores;
        }
    }
}
