#pragma once

#include "score.h"
#include <util/generic/ptr.h>

namespace NCrypta {
    namespace NGraphEngine {

        class TAbstractScoringStrategy {
        public:
            TAbstractScoringStrategy() = default;
            explicit TAbstractScoringStrategy(const TString& name) : Name(name) {}
            TAbstractScoringStrategy(const TString& name, double weight) : Name(name), DefaultWeight(weight) {}
            virtual ~TAbstractScoringStrategy() = default;

            virtual double ComputeScore(const TGraph& /*graph*/) const = 0;
            virtual double ComputeWeight(const TGraph& /*graph*/) const;
            TScoreBase ComputeScoreBase(const TGraph& graph) const;
            TString GetName() const;
        protected:
            TString Name{};
            double DefaultWeight = 1.;
        };

        class TMultiScoringStrategy {
        public:
            TMultiScoringStrategy() = default;

            void Add(THolder<TAbstractScoringStrategy> strategyPtr);
            TScores ComputeGraphScores(const TGraph& graph) const;
        private:
            TVector<THolder<TAbstractScoringStrategy>> Strategies{};
        };
    }
}
