#include <crypta/graph/engine/score/native/lib/utils/lcs/lcs.h>
#include <crypta/graph/engine/score/native/lib/lcs_scores.h>
#include <util/generic/algorithm.h>
#include <util/generic/set.h>

#include "lcs_scores.h"

namespace NCrypta {
    namespace NGraphEngine {
        static const i64 MAX_COUNT = 40;

        double TSimpleLcsScoringStrategy::ComputeLcsScore(const TGraph& graph) const {
            TVector<TString> allIds;
            FillIds(graph, &allIds);
            TSet<TString> ids(allIds.begin(), allIds.end());

            if (ids.size() < 2 || ids.size() > MAX_COUNT) {
                return 0.0;
            }
            auto idsiter = ids.begin();
            TString lcs = *idsiter;
            idsiter++;
            for (; idsiter != ids.end(); idsiter++) {
                lcs = LongestCommonSubstring(lcs, *idsiter);
            }

            return lcs.length();
        }

        double TAverageBestLcsScoringStrategy::ComputeLcsScore(const TGraph& graph) const {
            TVector<TString> ids;
            FillIds(graph, &ids);

            size_t size = ids.size();
            if (size < 2 || size > MAX_COUNT) {
                return 0.0;
            }

            TVector<double> bestLCS(size, 0);

            for (size_t i = 0; i < size; i++) {
                for (size_t j = i + 1; j < size; j++) {
                    double temp_lcs = LongestCommonSubstringLength(ids[i], ids[j]);

                    bestLCS[i] = Max(bestLCS[i], temp_lcs);
                    bestLCS[j] = Max(bestLCS[j], temp_lcs);
                }
            }

            return Accumulate(bestLCS, 0.) / size;
        }

        double TMedianPairwiseLcsScoringStrategy::ComputeLcsScore(const TGraph& graph) const {
            TVector<TString> ids;
            FillIds(graph, &ids);

            size_t size = ids.size();
            if (size < 2 || size > MAX_COUNT) {
                return 0.0;
            }

            TVector<size_t> lcs;
            for (size_t i = 0; i < size; i++) {
                for (size_t j = i + 1; j < size; j++) {
                    size_t temp_lcs = LongestCommonSubstringLength(ids[i], ids[j]);
                    lcs.push_back(temp_lcs);
                }
            }

            Sort(lcs.begin(), lcs.end());
            size_t length = lcs.size();

            double median;

            if (length % 2 == 0) {
                median = double(lcs[length / 2 - 1] + lcs[length / 2]) / 2.0;
            } else {
                median = double(lcs[length / 2]);
            }

            return median;
        }

    }
}
