#pragma once

#include <crypta/graph/engine/score/native/lib/utils/getters.h>
#include <crypta/graph/engine/score/native/lib/base/strategy.h>
#include "counts.h"

namespace NCrypta {
    namespace NGraphEngine {
        // ============= Abstract score classes
        class TAbstractLcsStrategy: public TAbstractCountScoringStrategy {
        public:
            using TAbstractCountScoringStrategy::TAbstractCountScoringStrategy;
            ~TAbstractLcsStrategy() = default;

            virtual void FillIds(const TGraph& /*graph*/, TVector<TString>* /*ids*/) const = 0;
            virtual double ComputeLcsScore(const TGraph& graph) const = 0;

            virtual ui64 Count(const TGraph& graph) const override {
                return static_cast<ui64>(ComputeLcsScore(graph));
            }
        };

        class TSimpleLcsScoringStrategy: public TAbstractLcsStrategy {
        public:
            using TAbstractLcsStrategy::TAbstractLcsStrategy;

            virtual void FillIds(const TGraph& /*graph*/, TVector<TString>* /*ids*/) const = 0;
            double ComputeLcsScore(const TGraph& graph) const;
        };

        class TAverageBestLcsScoringStrategy: public TAbstractLcsStrategy {
        public:
            using TAbstractLcsStrategy::TAbstractLcsStrategy;

            void FillIds(const TGraph& /*graph*/, TVector<TString>* /*ids*/) const override = 0;
            double ComputeLcsScore(const TGraph& graph) const override;
        };

        class TMedianPairwiseLcsScoringStrategy: public TAbstractLcsStrategy {
        public:
            using TAbstractLcsStrategy::TAbstractLcsStrategy;

            virtual void FillIds(const TGraph& /*graph*/, TVector<TString>* /*ids*/) const = 0;
            double ComputeLcsScore(const TGraph& graph) const;
        };

        // ============= Score classes
        // =============== For emails
        class TEmailsSimpleLcsScoringStrategy: public TSimpleLcsScoringStrategy {
        public:
            using TSimpleLcsScoringStrategy::TSimpleLcsScoringStrategy;
            void FillIds(const TGraph& graph, TVector<TString>* ids) const override {
                return FillEmails(graph, ids);
            }
        };

        class TEmailsAverageBestLcsScoringStrategy: public TAverageBestLcsScoringStrategy {
        public:
            using TAverageBestLcsScoringStrategy::TAverageBestLcsScoringStrategy;
            void FillIds(const TGraph& graph, TVector<TString>* ids) const override {
                return FillEmails(graph, ids);
            }
        };

        class TEmailsMedianPairwiseLcsScoringStrategy: public TMedianPairwiseLcsScoringStrategy {
        public:
            using TMedianPairwiseLcsScoringStrategy::TMedianPairwiseLcsScoringStrategy;
            void FillIds(const TGraph& graph, TVector<TString>* ids) const override {
                return FillEmails(graph, ids);
            }
        };

        // =============== For logins
        class TLoginsSimpleLcsScoringStrategy: public TSimpleLcsScoringStrategy {
        public:
            using TSimpleLcsScoringStrategy::TSimpleLcsScoringStrategy;
            void FillIds(const TGraph& graph, TVector<TString>* ids) const override {
                return FillLogins(graph, ids);
            }
        };

        class TLoginsAverageBestLcsScoringStrategy: public TAverageBestLcsScoringStrategy {
        public:
            using TAverageBestLcsScoringStrategy::TAverageBestLcsScoringStrategy;
            void FillIds(const TGraph& graph, TVector<TString>* ids) const override {
                return FillLogins(graph, ids);
            }
        };

        class TLoginsMedianPairwiseLcsScoringStrategy: public TMedianPairwiseLcsScoringStrategy {
        public:
            using TMedianPairwiseLcsScoringStrategy::TMedianPairwiseLcsScoringStrategy;
            void FillIds(const TGraph& graph, TVector<TString>* ids) const override {
                return FillLogins(graph, ids);
            }
        };

    }
}
