#pragma once

#include <crypta/graph/engine/score/proto/stats.grpc.pb.h>
#include "stats.h"

namespace NCrypta {
    namespace NGraphEngine {
        class TGraphScoreEngineImpl: public TGraphScoreEngine::Service {
        public:
            TGraphScoreEngineImpl() {
            }

            grpc::Status ComputeStats(grpc::ServerContext* /*context*/, const TGraphStatsArguments* args, TStats* stats) override {
                auto result = CollectProdStats(args->GetGraph(), args->GetOptions());
                stats->MergeFrom(result);
                return grpc::Status::OK;
            }
        };
    }
}
