#include <util/generic/vector.h>

#include "getters.h"

namespace NCrypta {
    namespace NGraphEngine {

        bool IsSyntheticLogin(const TString& login) {
            return login.StartsWith("phne-") || login.StartsWith("uid-");
        }

        void FillEmails(const TGraph& graph, TVector<TString>* emails) {
            for (const auto& vertex : graph.GetVertices()) {
                if (vertex.GetType() == EIdType::EMAIL) {
                    TString login = vertex.GetEmail().login();
                    if (IsSyntheticLogin(login)) {
                        continue;
                    }
                    emails->push_back(login);
                }
            }
        }

        void FillLogins(const TGraph& graph, TVector<TString>* logins) {
            for (const auto& vertex : graph.GetVertices()) {
                if (vertex.GetType() == EIdType::LOGIN) {
                    TString login = vertex.GetLogin().value();
                    if (IsSyntheticLogin(login)) {
                        continue;
                    }
                    logins->push_back(login);
                }
            }
        }

    }
}
