#include <util/generic/vector.h>

#include "lcs.h"

namespace NCrypta {
    namespace NGraphEngine {
        TString LongestCommonSubstring(const TString& a, const TString& b) {
            size_t lcsStart = 0;
            size_t lcsLength = 0;
            TVector<size_t> prevDp(b.size(), 0);
            TVector<size_t> dp(b.size(), 0);
            for (size_t i = 0; i < a.size(); i++) {
                for (size_t j = 0; j < b.size(); j++) {
                    if (a[i] == b[j]) {
                        size_t newLcsLength = (i == 0 || j == 0) ? 1 : (prevDp[j - 1] + 1);
                        dp[j] = newLcsLength;
                        if (newLcsLength > lcsLength) {
                            lcsStart = j - newLcsLength + 1;
                            lcsLength = newLcsLength;
                        }
                    } else {
                        dp[j] = 0;
                    }
                }
                dp.swap(prevDp);
            }
            return b.substr(lcsStart, lcsLength);
        }

        size_t LongestCommonSubstringLength(const TString& a, const TString& b) {
            return LongestCommonSubstring(a, b).size();
        }

    }
}
