#pragma once
#include <crypta/graph/engine/score/native/lib/stats.h>


namespace NCrypta {
    namespace NGraphEngine {

        TString CollectStats(const TString& protoGraph, const TString& protoOptions) {
            TGraph graph;
            TStatsOptions options;
            if (!graph.ParseFromString(protoGraph)) {
                ythrow yexception() << "Invalid graph proto";
            }
            if (!options.ParseFromString(protoOptions)) {
                ythrow yexception() << "Invalid options proto";
            }
            TStats stats = CollectProdStats(graph, options);
            TString result;
            Y_PROTOBUF_SUPPRESS_NODISCARD stats.SerializeToString(&result);
            return result;
         }
    }
}
