from util.generic.string cimport TString
from crypta.graph.engine.score.proto.stats_pb2 import (
    TStats,
)

cdef extern from "crypta/graph/engine/score/python/score.h"  namespace "NCrypta::NGraphEngine":
    TString CollectStats(const TString& protoGraph, const const TString& options) nogil


def _collect_stats(bytes proto_graph, bytes proto_options):
    cdef TString _proto_graph = proto_graph
    cdef TString _proto_options = proto_options
    with nogil:
        result = CollectStats(_proto_graph, _proto_options)
    return result


def collect_stats(graph, options):
    stats = TStats()
    stringStats = _collect_stats(
            graph.SerializeToString(), options.SerializeToString())
    stats.ParseFromString(stringStats)
    return stats
