from util.generic.string cimport TString
from crypta.lib.python.yql.client.proto cimport (
    Descriptor,
    yql_proto_field_name,
    yql_proto_field,
)
from crypta.lib.python.native_yt import job_by_name
from libcpp cimport bool

cdef extern from "crypta/graph/export/lib/native/register.h":
    pass

TMapEdgesWithActiveIdentifiers = job_by_name('NV2::TMapEdgesWithActiveIdentifiers')
TReduceEdgesWithActiveIdentifiers = job_by_name('NV2::TReduceEdgesWithActiveIdentifiers')
TFilterUnchangedGraphs = job_by_name('NV2::TFilterUnchangedGraphs')
TReduceTVEdges = job_by_name('NV2::TReduceTVEdges')
TEmptyMapper = ""
TCombine = job_by_name('NV2::TCombine')
TProfileFilterMapper = job_by_name('TProfileFilterMapper')
TJoinTVEdgesWithCryptaID = job_by_name('NV2::TJoinTVEdgesWithCryptaID')
TFilterUsedTVEdges = job_by_name('NV2::TFilterUsedTVEdges')
TFilterReducer = job_by_name('TFilterReducer')


cdef extern from *:
    ctypedef unsigned long long ui64

cdef extern from "crypta/graph/export/lib/native/native.h":
    ui64 ConvertToCryptaId(const TString& id)

cdef extern from "crypta/graph/lib/util/util.h":
    bool IsYuidPrivate(const TString& date, const TString& yuid)
    TString ConvertMacToMD5(const TString& mac)

cdef extern from "crypta/graph/export/lib/proto/messages.pb.h":
    cppclass TISGraph "crypta::idserv::proto::TGraph":
        @staticmethod
        Descriptor* descriptor()

    cppclass Profile "yabs::proto::Profile":
        @staticmethod
        Descriptor* descriptor()

def graph_yql_proto_fields():
    return {
        yql_proto_field_name("graph"): yql_proto_field(TISGraph.descriptor())
    }

def profile_yql_proto_fields():
    return {
        yql_proto_field_name("ProfileDump"): yql_proto_field(Profile.descriptor())
    }

def convert_to_crypta_id(bytes value):
    return ConvertToCryptaId(value)

def is_yuid_private(bytes date, bytes yuid):
    return IsYuidPrivate(date, yuid)

def convert_mac_to_md5(bytes mac):
    return ConvertMacToMD5(mac)
