#pragma once

#include <util/generic/hash_set.h>



namespace NV2 {

    static const TString ID_VALUE("id_value");
    static const TString IDFA("idfa");
    static const TString GAID("gaid");
    static const TString PUID("puid");
    static const TString UUID("uuid");
    static const TString YANDEXUID("yandexuid");
    static const TString DUID("duid");
    static const TString PRIVATE_YANDEXUID("private_yandexuid");
    static const TString MM_DEVICE_ID("mm_device_id");
    static const TString XUNIQ_GUID("xuniq_guid");
    static const TString MAC("mac");
    static const TString MAC_EXT_MD5("mac_ext_md5");
    static const TString EMAIL("email");
    static const TString EMAIL_MD5("email_md5");
    static const TString PHONE("phone");
    static const TString PHONE_MD5("phone_md5");
    static const i64 MAX_NODES_COUNT_PER_GRAPH(2000);
    static const i64 MAX_EDGES_COUNT_PER_GRAPH(5000);
    static const i64 MAX_TV_EDGES_PER_NODE(10);
    static const THashSet<TString> NODE_TYPES_FOR_FILTERING = THashSet<TString>{YANDEXUID, UUID, GAID, MM_DEVICE_ID, PRIVATE_YANDEXUID, DUID};

    namespace NSourceTypes {
        static const TString SMART_TV("smart-tv");
        static const TString V1_COMPATIBILITY("v1-compatibility");
    }

    namespace NLogSources {
        static const TString EXPORT("export");
    }

    namespace NVertexAttributes {
        static const TString QUERIES_COUNT("queries_count");
        static const TString PROFILE_SIZE("profile_size");
        static const TString DAYS_COUNT("days_count");
        static const TString WEIGHT("weight");
    }

    namespace NEdgeAttributes {
        static const TString ID_VALUE("id_value");
        static const TString PAIR_SOURCE("pair_source");
        static const TString SOURCE_TYPE("source_type");
        static const TString LOG_SOURCE("log_source");
        static const TString INDEVICE("indevice");
        static const TString WEIGHT("weight");
    }

    namespace NEdgeV2Fields {
        static const TString CRYPTA_ID("cryptaId");
        static const TString ID("id");
        static const TString ID_TYPE("id_type");
        static const TString ID_1("id1");
        static const TString ID_1_TYPE("id1Type");
        static const TString ID_2("id2");
        static const TString ID_2_TYPE("id2Type");
        static const TString LOG_SOURCE("logSource");
        static const TString SOURCE_TYPE("sourceType");
        static const TString INDEVICE("indevice");
        static const TString DATES("dates");
        static const TString SURVIVAL_WEIGHT("survivalWeight");
    }

    namespace NIdentifierFields {
        static const TString ID("id");
        static const TString ID_TYPE("id_type");
        static const TString DATES("dates");
    }

}
