#include "native.h"
#include <crypta/lib/native/identifiers/lib/id_types/all.h>
#include <ads/bsyeti/libs/experiments/user_ids/user_ids.h>


void TProfileFilterMapper::Do(TTableReader<TRecordWithProfile>* input, TTableWriter<TRecordWithProfile>* output) {
    ui32 oldestActiveTimestamp = State->GetOldestBBActiveTimestamp();

    for (; input->IsValid(); input->Next()) {
        auto& row = input->GetRow();
        TRecordWithProfile out;
        bool isYandexuid = false;
        const auto [id, type] = NExperiments::ConvertFromStorageUid<TString>(row.GetUniqID());
        if (type == NExperiments::EUserIdType::UniqId) {
            auto yandexuid = NIdentifiers::TYandexuid(id);
            isYandexuid = true;
            if (!yandexuid.IsValid()) {
                continue;
            }
            out.SetID(yandexuid.Value());
            out.SetIDType(NV2::YANDEXUID);
        } else if (type == NExperiments::EUserIdType::Gaid) {
            auto gaid = NIdentifiers::TGaid(id);
            if (!gaid.IsValid()) {
                continue;
            }
            out.SetID(gaid.Value());
            out.SetIDType(NV2::GAID);
        } else if (type == NExperiments::EUserIdType::Idfa) {
            auto idfa = NIdentifiers::TIdfa(id);
            if (!idfa.IsValid()) {
                continue;
            }
            out.SetID(idfa.Value());
            out.SetIDType(NV2::IDFA);
        } else if (type == NExperiments::EUserIdType::Uuid) {
            auto uuid = NIdentifiers::TUuid(id);
            if (!uuid.IsValid()) {
                continue;
            }
            out.SetID(uuid.Value());
            out.SetIDType(NV2::UUID);
        } else if (type == NExperiments::EUserIdType::PassportUid) {
            auto puid = NIdentifiers::TPuid(id);
            if (!puid.IsValid()) {
                continue;
            }
            out.SetID(puid.Value());
            out.SetIDType(NV2::PUID);
        } else if (type == NExperiments::EUserIdType::Duid) {
            auto duid = NIdentifiers::TDuid(id);
            if (!duid.IsValid()) {
                continue;
            }
            out.SetID(duid.Value());
            out.SetIDType(NV2::DUID);
        } else {
            continue;
        }

        yabs::proto::Profile profile;
        if (!profile.ParseFromString(row.GetProfile())) {
            continue;
        }
        auto queriesCount = GetQueriesCount(profile);
        auto lastUpdateTime = GetLastUpdateTime(profile);

        if (oldestActiveTimestamp <= lastUpdateTime) {

            out.SetTimestamp(lastUpdateTime);
            out.SetQueriesCount(queriesCount);
            out.SetProfileSize(row.GetProfile().size());
            output->AddRow(out);

            if (isYandexuid) {
                output->AddRow(out, 1);
            }
        }
    }
}

void TFilterReducer::Do(TTableReader<TRecordWithProfile>* input, TTableWriter<TRecordWithProfile>* output) {
    TRecordWithProfile out(input->GetRow());
    out.SetIDType("yandexuid");
    for (; input->IsValid(); input->Next()) {
        auto& row = input->GetRow();
        if (row.GetTimestamp() > out.GetTimestamp()) {
            out.SetTimestamp(row.GetTimestamp());
        }
        if (row.GetQueriesCount() > out.GetQueriesCount()) {
            out.SetQueriesCount(row.GetQueriesCount());
        }
    }
    output->AddRow(out);
}

void NV2::TFilterUnchangedGraphs::Do(TTableReader<TGraphRecord>* input, TTableWriter<TGraphRecord>* output) {
    TGraphRecord graphOld;
    TGraphRecord graphNew;
    for (; input->IsValid(); input->Next()) {
        auto tableIndex = static_cast<int>(input->GetTableIndex());
        if (tableIndex == 0) {
            graphNew = input->GetRow();
        } else {
            graphOld = input->GetRow();
        }
    }
    if (graphNew.GetCryptaID() && !google::protobuf::util::MessageDifferencer::Equals(graphNew, graphOld)) {
        output->AddRow(graphNew);
    }
}
