from crypta.graph.soup.config.python import EDGE_TYPE as edge_types
from crypta.graph.soup.config.proto.edge_type_pb2 import TEdgeProps


edge_strength_weights = {
    TEdgeProps.USUAL: 1.0,
    TEdgeProps.TRUSTED: 2.0,
    TEdgeProps.ARTIFICIAL: 3.0
}


def _get_attribute_value(proto_node, attr_name, default_value=None):
    kv = [a.Value for a in proto_node.Attributes if a.Name == attr_name]
    return kv[0] if kv else default_value


def get_edge_weight(proto_graph, edge):
    weight = float(_get_attribute_value(edge, 'weight', default_value=0.0))

    try:
        source_type = _get_attribute_value(edge, 'source_type')
        log_source = _get_attribute_value(edge, 'log_source')
        id1_type = proto_graph.Nodes[edge.Node1].Type
        id2_type = proto_graph.Nodes[edge.Node2].Type

        edge_type = edge_types.get_edge_type_by_name(id1_type, id2_type, source_type, log_source)
        edge_strength = edge_type.Props.EdgeStrength
    except Exception:
        edge_strength = TEdgeProps.UNKNOWN

    edge_strength_weight = edge_strength_weights.get(edge_strength, 0.0)

    return weight * edge_strength_weight


def cleanup_edges_weight(proto_graph):
    for edge in proto_graph.Edges:
        filtered_attrs = [a for a in edge.Attributes if a.Name != 'weight']

        del edge.Attributes[:]
        edge.Attributes.extend(filtered_attrs)

    return proto_graph
