"""Converts crypta/graph matching data to export format. The output
table is to be read by crypta/idserv.

Usage:
    ./export VERSION DIFF [SOURCE DESTINATION]

"""

from crypta.lib.python.getoptpb import ParsePbOptions
import crypta.graph.export.config.proto.config_pb2 as config

from docopt import docopt
from crypta.graph.export.lib.graphs import Exporter
import crypta.lib.python.bt.conf.conf as conf
import crypta.lib.python.bt.conf.resource_conf as resource_conf
from yt.wrapper import YtClient
import os

import logging
logger = logging.getLogger(__name__)


def main():
    if os.environ.get('USE_PROTO_CONFIG'):
        conf.use(resource_conf.find())
        conf.use_proto(ParsePbOptions(config.TGraphExportConfig))

        version = conf.proto.Version
        diff_only = conf.proto.Diff
        source = conf.proto.Source
        output_root = conf.proto.Destination

        client = YtClient(proxy=conf.proto.Yt.Proxy, token=conf.proto.Yt.Token)

        exporter = Exporter(client)
        exporter.export(version, diff_only, (source, output_root) if source else None)
    else:
        args = docopt(__doc__)
        version = args['VERSION'].upper()
        diff_only = int(args['DIFF'])
        source = args.get("SOURCE")
        output_root = args.get("DESTINATION")

        conf.use(resource_conf.find())
        client = YtClient(proxy=conf.Yt.Proxy, token=conf.Yt.Token)
        client.config['pool'] = conf.Yt.Pool

        exporter = Exporter(client)
        exporter.export(version, diff_only, (source, output_root) if source else None)
