#include <crypta/idserv/data/graph_test_utils.h>
#include <crypta/graph/export/serializers/graph/proto/graph_proto_serializer.h>

#include <library/cpp/testing/benchmark/bench.h>
#include <util/generic/xrange.h>

using namespace NCrypta::NIS;

Y_CPU_BENCHMARK(Serialize, iface) {
    TGraph graph = CreateGraph(100, 200);

    for (const auto i : xrange(iface.Iterations())) {
        Y_UNUSED(i);

        TGraphProtoSerializer::Serialize(graph);
    }
}

Y_CPU_BENCHMARK(Deserialize, iface) {
    TGraph graph = CreateGraph(100, 200);
    const auto& serializedGraph = TGraphProtoSerializer::Serialize(graph);

    for (const auto i : xrange(iface.Iterations())) {
        Y_UNUSED(i);

        TGraphProtoSerializer::Deserialize(serializedGraph);
    }
}
