#pragma once

#include <crypta/idserv/data/graph.h>
#include <crypta/graph/export/proto/graph.pb.h>

namespace NCrypta {
    namespace NIS {
        class TGraphProtoSerializer {
            using TAttributesProto = google::protobuf::RepeatedPtrField<crypta::idserv::proto::TAttribute>;

        public:
            using TGraphProto = crypta::idserv::proto::TGraph;

            static TString Serialize(const TGraph& graph);
            static void Serialize(TGraphProto& proto, const TGraph& graph);

            static TGraph Deserialize(const TStringBuf& protoStr);
            static void Deserialize(TGraph& graph, const TGraphProto& proto);

        private:
            static void SerializeAttributes(TAttributesProto& proto, const TAttributes& attributes);
            static void DeserializeAttributes(TAttributes& attributes, const TAttributesProto& proto);
        };
    }
}
