from crypta.idserv.data.graph cimport TGraph as TGraphImpl
from crypta.idserv.data.python.graph cimport TGraph
from crypta.graph.export.serializers.graph.proto.graph_proto_serializer cimport TGraphProtoSerializer as TGraphProtoSerializerImpl
from util.generic.string cimport TString


cdef extern from "<utility>" namespace "std" nogil:
    cdef TGraphImpl move(TGraphImpl)

cdef class TGraphProtoSerializer:
    @staticmethod
    def Serialize(TGraph graph):
        return TGraphProtoSerializerImpl.Serialize(graph.Impl)

    @staticmethod
    def Deserialize(TString protoStr):
        graph = TGraph()
        graph.Impl = move(TGraphProtoSerializerImpl.Deserialize(protoStr))
        return graph
