#pragma once

#include "socket.h"
#include <memory>
#include <sys/mman.h>
#include <linux/if_packet.h>

struct TBufferOptions {
    ui32 BlockSize = 1 << 22;
    ui32 FrameSize = 1 << 11;
    ui32 BlockNum = 64;
    ui32 WaitForDataMs = 50;
    int FanoutType = PACKET_FANOUT_HASH;
    int FanoutId = -1;
};

struct TBlockData {
    ui32 version;
    ui32 offset_to_priv;
    struct tpacket_hdr_v1 h1;
};

class TCaptureBuffers {
public:
    TCaptureBuffers(std::unique_ptr<TInterfaceBindedSocket> socket, TBufferOptions options = {});
    ~TCaptureBuffers();
    int fd() const;
    TBlockData* GetBlock(ui32 index) const;
    void FlushBlock(ui32 index);
    static bool IsBlockWithData(TBlockData* block);

private:
    void SetPacketVersion();
    void SetupRingBuffers();
    void SetFanOutGroup();
    void CleanUp();

    std::unique_ptr<TInterfaceBindedSocket> Socket;
    const TBufferOptions Options;
    iovec* Blocks = nullptr;
    ui8* BlocksMemory = (ui8*)MAP_FAILED;
};
