#include "capturer.h"
#include <memory>
#include <poll.h>

namespace {
    TCaptureBuffers MakeBuffers(const TCaptureOptions& options) {
        auto raw_socket = std::make_unique<TInterfaceBindedSocket>(options.GetInterfaceName());
        TBufferOptions bufferOptions{
            .BlockSize = options.GetBlockSize(),
            .FrameSize = options.GetFrameSize(),
            .BlockNum = options.GetBlockNum(),
            .WaitForDataMs = options.GetWaitForDataMs()};
        return TCaptureBuffers(std::move(raw_socket), bufferOptions);
    }
}

TCapturer::TCapturer(TCaptureOptions options)
    : Options(std::move(options))
    , Buffers(MakeBuffers(Options))
    , CurrentBlock(0)
{
}

TCurrentBlock TCapturer::GetCurrentBlock() const {
    return {
        Buffers.GetBlock(CurrentBlock),
        CurrentBlock
    };
}

void TCapturer::FlushCurrentBlock() {
    Buffers.FlushBlock(CurrentBlock);
    CurrentBlock = (CurrentBlock + 1) % Options.GetBlockNum();
}

bool TCurrentBlock::IsWithData() {
    return TCaptureBuffers::IsBlockWithData(Data);
}

void TCapturer::WaitForData() {
    pollfd pfd;
    memset(&pfd, 0, sizeof(pfd));

    pfd.fd = Buffers.fd();
    pfd.events = POLLIN | POLLERR;
    pfd.revents = 0;

    poll(&pfd, 1, -1);
}
