#pragma once

#include "buffers.h"
#include "socket.h"

#include <crypta/graph/fast_catcher/proto/options.pb.h>

struct TCurrentBlock {
    TBlockData* Data;
    ui32 Index;

    bool IsWithData();
};

class TCapturer {
public:
    TCapturer(TCaptureOptions config);
    TCurrentBlock GetCurrentBlock() const;
    void FlushCurrentBlock();
    void WaitForData();

private:
    const TCaptureOptions Options;
    TCaptureBuffers Buffers;
    ui32 CurrentBlock;
};
