#pragma once

#include "capturer.h"
#include <functional>
#include <optional>
#include <util/generic/hash.h>

class TTcpOptions : public THashMap<ui8, TString> {
public:
    enum ETcpOptions {
        ENDOFOPTIONLIST = 0,
        NOOPERATION = 1,
    };
};

struct TRawPacket {
    ui16 EtherProto;
    ui8 PacketType;
    ui8* Data;
    ui32 Size;
};

struct TBlockInfo {
    ui32 NPackets;
};

struct TUserInfo {
    in_addr Src4;
    in_addr Dst4;
    in6_addr Src6;
    in6_addr Dst6;

    ui16 SrcPort;
    ui16 DstPort;
    int AddressFamily;
    TTcpOptions TcpOptions;
    uint8_t Reserved;
};

TBlockInfo ParseBlock(const TCurrentBlock& block, std::function<void(const TRawPacket&)> callback);
std::optional<TUserInfo> ParseV4(const TRawPacket& packet);
std::optional<TUserInfo> ParseV6(const TRawPacket& packet);
