#include "sender.h"
#include <crypta/lib/native/resolver/resolver.h>
#include <optional>

TSender::TSender(TSenderOptions options)
    : Options(std::move(options))
    , ResolveResult(NCrypta::NResolver::Resolve(Options.Destination))
    , AddressFamily(ResolveResult.SelectedFamily())
    , Socket(AddressFamily)
    , SenderQueue(TThreadPool::TParams().SetBlocking(true).SetCatching(true))
{
    SenderQueue.Start(Options.NWorkers, Options.QueueSize);
}

void TSender::Enqueue(TString data) {
    auto unused = SenderQueue.AddFunc([this, &data]() {
        Cout << "enqueuing " << data.size() << " bytes: '" << data << "'" << Endl;

        switch(AddressFamily) {
            case AF_INET: {
                struct sockaddr_in sa;
                sa.sin_family = AF_INET;
                sa.sin_port = htons(Options.Port);
                sa.sin_addr = std::get<in_addr>(ResolveResult);

                sendto(Socket.fd(), data.c_str(), data.size(), 0, (const struct sockaddr *) &sa, sizeof(sa));

                break;
            }

            case AF_INET6: {
                struct sockaddr_in6 sa;
                sa.sin6_family = AF_INET6;
                sa.sin6_port = htons(Options.Port);
                sa.sin6_addr = std::get<in6_addr>(ResolveResult);

                sendto(Socket.fd(), data.c_str(), data.size(), 0, (const struct sockaddr *) &sa, sizeof(sa));

                break;
            }
        }
    });

    Y_UNUSED(unused);
}
