#pragma once

#include "parser.h"
#include "socket.h"
#include <crypta/lib/native/resolver/resolver.h>
#include <util/thread/pool.h>

class TSender {
public:
    struct TSenderOptions {
        // int Protocol;
        TString Destination;
        uint16_t Port;
        uint32_t NWorkers;
        uint32_t QueueSize;
    };
    TSender(TSenderOptions options);
    void Enqueue(TString data);
private:
    TSenderOptions Options;
    NCrypta::NResolver::TResolveResult ResolveResult;
    int AddressFamily;
    TTcpUdpSocket Socket;
    TThreadPool SenderQueue;
};
