#pragma once

#include <util/generic/string.h>
#include <net/if.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <unistd.h>

class TRawSocket {
public:
    TRawSocket();
    ~TRawSocket();
    TRawSocket(const TRawSocket&) = delete;
    TRawSocket& operator=(const TRawSocket&) = delete;
    int fd() const;

private:
    int SocketFd;
};

class TTcpUdpSocket {
public:
    TTcpUdpSocket(int family=AF_INET, int protocol = SOCK_DGRAM);
    ~TTcpUdpSocket();
    TTcpUdpSocket(const TTcpUdpSocket&) = delete;
    TTcpUdpSocket& operator=(const TTcpUdpSocket&) = delete;
    int fd() const;

    const int AddressFamily;
private:
    int SocketFd = -1;
};

class TInterfaceBindedSocket {
public:
    TInterfaceBindedSocket(const TString& interfaceName);
    int fd() const;

private:
    TRawSocket Socket;
    const TString InterfaceName;
    int InterfaceIndex;
};
