import datetime
import logging
import sys

import crypta.lib.python.bt.tasks.tool2 as task
from crypta.lib.python.getoptpb import ParsePbOptions

import crypta.graph.fingerprint.proto.config_pb2 as proto_config
import crypta.graph.fingerprint.lib  # noqa
import crypta.graph.fingerprint.match.appmetrica.lib  # noqa
import crypta.graph.fingerprint.match.ssp.lib  # noqa

import crypta.lib.python.bt.conf.conf as conf


def main():
    if not logging.root.handlers:
        logging.root.addHandler(logging.StreamHandler(sys.stderr))
    conf.use_proto(ParsePbOptions(proto_config.TFingerprintConfig))

    if conf.proto.Date == "today":
        conf.proto.Date = datetime.datetime.now().strftime("%Y-%m-%d")
    elif conf.proto.Date == "yesterday":
        conf.proto.Date = (datetime.datetime.now() - datetime.timedelta(1)).strftime("%Y-%m-%d")

    # validate date format
    datetime.datetime.strptime(str(conf.proto.Date), "%Y-%m-%d")

    sys.exit(task.main(conf.proto))


if __name__ == "__main__":
    main()
