
$intput_path = '{{ input_path }}';
$output_path = '{{ output_path }}';

$data = (
    SELECT
        *
    FROM
        $intput_path
    WHERE
        AppPlatform == "iOS"
        AND DeviceID is not NULL
        AND APIKey == 13
        AND EventType == 28 -- IDENTITY_LIGHT event
);

$parse_ev_28 = ($str) -> {
    $dfid = Yson::Lookup(Yson::ParseJson($str, Yson::Options(false as Strict)), "dfid");
    RETURN AsStruct(
        IF(Yson::Contains($dfid, "tds"), Yson::LookupUint64($dfid, "tds"), 0) AS tds,
        IF(Yson::Contains($dfid, "fds"), Yson::LookupUint64($dfid, "fds"), 0) AS fds,
        IF(Yson::Contains($dfid, "boot_time"), Yson::LookupInt64($dfid, "boot_time"), 0) AS boot_time,
        IF(Yson::Contains($dfid, "emoji"), Yson::ConvertToStringList(Yson::Lookup($dfid, "emoji")), AsLIst()) AS emoji,
    );
};


$empty_idfa = "00000000-0000-0000-0000-000000000000";

$ids =   SELECT
        CryptaID,
        DeviceID,
        IF(OriginalDeviceID != $empty_idfa, OriginalDeviceID) AS idfa,
        Digest::MurMurHash(String::JoinFromList(AsList(
            CAST($parse_ev_28(EventValue).tds AS String),
            CAST($parse_ev_28(EventValue).boot_time AS String),

            CAST(`OriginalModel` AS String),
            CAST(`Model` AS String),
            CAST(`ScaleFactor` AS String),
            CAST(`Locale` AS String),
            CAST(`ScreenHeight` AS String),
            CAST(`ScreenWidth` AS String),
            CAST(`OperatorID` AS String),
            CAST(`OSVersion` AS String),
        ), "_")) AS fp
    FROM $data
;

$id_type = SELECT Identifiers::MmDeviceId("").IdType;

$output_ids = (
    SELECT
        fp AS fp,
        DeviceID AS id,
        $id_type AS id_type,
        MAX(idfa) AS idfa,
        MAX(CryptaID) AS CryptaID
    FROM $ids
    GROUP BY (fp, DeviceID)
);

INSERT INTO $output_path WITH TRUNCATE
SELECT * FROM $output_ids;
