PRAGMA yt.MaxRowWeight = "32M";

$location_p = CAST('{{ location_p }}' AS Uint8);
$timestamp_p = CAST('{{ timestamp_p }}' AS Int64);

$input_path = '{{ input_path }}';
$output_path = '{{ output_path }}';


$data = (
    SELECT
        *
    FROM
        $input_path
    WHERE
        AppPlatform == "iOS"
        AND DeviceID is not NULL
        AND ClientIP != "::"
        AND Latitude IS NOT NULL
        AND Longitude IS NOT NULL
        AND CAST(Latitude AS Double) BETWEEN -90 AND 90
        AND CAST(Longitude AS Double) BETWEEN -180 AND 180
        AND LocationTimestamp IS NOT NULL
);

$empty_idfa = "00000000-0000-0000-0000-000000000000";

$ids = (
    SELECT
        IF(IFA != $empty_idfa, IFA) AS idfa,
        DeviceID,
        Digest::MurMurHash(String::JoinFromList(AsList(
            `ClientIP`,
            `OSVersion`,
            `LocationSource`,
            `IsRooted`,
            `DeviceType`,
            GeoHash::EncodeToString(CAST(Latitude AS Double), CAST(Longitude AS Double), $location_p),
            CAST(CAST(`LocationTimestamp` AS Int64) - CAST(`LocationTimestamp` AS Int64) % $timestamp_p AS String)
        ), "_")) AS fp
    FROM $data
);

$id_type = SELECT Identifiers::MmDeviceId("").IdType;

$output_ids = (
    SELECT
        fp AS fp,
        DeviceID AS id,
        $id_type AS id_type,
        MAX(idfa) AS idfa,
        null AS CryptaID
    FROM $ids
    GROUP BY (fp, DeviceID)
);

INSERT INTO $output_path WITH TRUNCATE
SELECT * FROM $output_ids;
