PRAGMA yt.MaxRowWeight = "32M";


$timestamp_p = CAST('{{ timestamp_p }}' AS Int64);

$intput_path = '{{ input_path }}';
$output_path = '{{ output_path }}';

$data = (
    SELECT
        *
    FROM
        $intput_path
    WHERE
        AppPlatform == "iOS"
        AND DeviceID is not NULL
        AND APIKey == 13
        AND ClientIP != Ip::FromString("::")
);

$empty_idfa = "00000000-0000-0000-0000-000000000000";

$ids =   SELECT
        CryptaID,
        DeviceID,
        IF(OriginalDeviceID != $empty_idfa, OriginalDeviceID) AS idfa,
        Digest::MurMurHash(String::JoinFromList(AsList(
            CAST(`ClientIP` AS String),
            CAST(`DeviceType` AS String),
            CAST(`ScreenDPI` AS String),
            CAST(`OriginalModel` AS String),
            CAST(`Model` AS String),
            CAST(`ScaleFactor` AS String),
            CAST(`OSApiLevel` AS String),
            CAST(`CountryCode` AS String),
            CAST(`SendTimeZone` AS String),
            CAST(`EventTimeZone` AS String),
            CAST(`StartTimeZone` AS String),
            CAST(`OperatorID` AS String),
            CAST(`OperatorName` AS String),
            CAST(`Locale` AS String),
            CAST(`ScreenHeight` AS String),
            CAST(`OSVersion` AS String),
            CAST(`ScreenWidth` AS String),
            CAST(`RegionTimeZone` AS String),
            CAST(`RegionID` AS String),

            CAST(CAST(`StartTimestamp` AS Int64) - CAST(`StartTimestamp` AS Int64) % $timestamp_p AS String)
        ), "_")) AS fp
    FROM $data
;

$id_type = SELECT Identifiers::MmDeviceId("").IdType;

$output_ids = (
    SELECT
        fp AS fp,
        DeviceID AS id,
        $id_type AS id_type,
        MAX(idfa) AS idfa,
        MAX(CryptaID) AS CryptaID
    FROM $ids
    GROUP BY (fp, DeviceID)
);

INSERT INTO $output_path WITH TRUNCATE
SELECT * FROM $output_ids;
