
$intput_path = '{{ input_path }}';
$output_path = '{{ output_path }}';

$data = (
    SELECT
        *
    FROM
        $intput_path
    WHERE
        AppPlatform == "iOS"
        AND DeviceID is not NULL
        AND APIKey == 13
        AND ClientIP != Ip::FromString("::")
);

$empty_idfa = "00000000-0000-0000-0000-000000000000";

$ids =   SELECT
        CryptaID,
        DeviceID,
        IF(OriginalDeviceID != $empty_idfa, OriginalDeviceID) AS idfa,
        Digest::MurMurHash(
            String::JoinFromList(AsList(
                Ip::ToString(`ClientIP`),
                OSVersion
            ), "_")
        ) AS fp
    FROM $data
;

$id_type = SELECT Identifiers::MmDeviceId("").IdType;

$output_ids = (
    SELECT
        fp AS fp,
        DeviceID AS id,
        $id_type AS id_type,
        MAX(idfa) AS idfa,
        MAX(CryptaID) AS CryptaID
    FROM $ids
    GROUP BY (fp, DeviceID)
);

INSERT INTO $output_path WITH TRUNCATE
SELECT * FROM $output_ids;
