USE hahn;
PRAGMA yt.MaxRowWeight = "128M";
PRAGMA yt.Pool = "crypta_graph";

$intput_path = '{{ input_path }}';
$output_path = '{{ output_path }}';
$output_stats = '{{ output_stats }}';


$data = (
    SELECT * FROM
     $intput_path
     WHERE
     -- for check
     OriginalDeviceID IS NOT NULL
     AND AppPlatform == "iOS"
     AND DeviceID is not NULL
     AND APIKey == 13
);


$ids = (
    SELECT
        OriginalDeviceID AS idfa,
        DeviceID AS mm_device_id,
        Digest::MurMurHash(String::JoinFromList(AsList(
            CAST(`AppPlatform` AS String),
            CAST(`DeduplicationEnabled` AS String),
            CAST(`DeviceType` AS String),
            CAST(`IsInstallationTrackingEnabled` AS String),
            CAST(`ScreenDPI` AS String),
            CAST(`OriginalModel` AS String),
            CAST(`Model` AS String),
            CAST(`ScaleFactor` AS String),
            CAST(`OSApiLevel` AS String),
            CAST(`CountryCode` AS String),
            CAST(`StartTimeZone` AS String),
            CAST(`OperatorID` AS String),
            CAST(`EventSource` AS String),
            CAST(`LimitAdTracking` AS String),
            CAST(`OperatorName` AS String),
            CAST(`Locale` AS String),
            CAST(`AppDebuggable` AS String),
            CAST(`OSVersion` AS String),
            CAST(`ScreenHeight` AS String),
            CAST(`ScreenWidth` AS String)
        ), "_")) AS fp
    FROM $data
);

$id_type = SELECT IdType::MM_DEVICE_ID();

$output_ids = (
    SELECT
        mm_device_id AS id,
        $id_type AS id_type,
        SOME(fp) AS fp,

        COUNT(DISTINCT fp) AS cnt,
        COUNT(*) AS totalCnt
    FROM $ids
    GROUP BY mm_device_id
);

INSERT INTO $output_path WITH TRUNCATE
SELECT * FROM $output_ids;

INSERT INTO $output_stats WITH TRUNCATE
SELECT
    COUNT_IF(cnt == 1) AS uniqueCnt,
    COUNT(*) AS totalCnt,
    (COUNT_IF(cnt == 1) + 0.) / COUNT(*) AS rate
FROM $output_ids;

