$timestamp = {{ ts }};
$ids = '{{ input_path }}';
$output_pairs = '{{ output_path }}';
$output_stats = '{{ output_stats }}';
$max_fp_size = {{ max_fp_size }};
$fp_type = '{{ fp_type }}';



$ids = (
    SELECT
        fp,
        id,
        id_type,
        idfa,
        CryptaID,
        idfa IS NOT NULL AND idfa != "00000000-0000-0000-0000-000000000000" AS withIdfa,
        CryptaID IS NOT NULL AND CryptaID != 0 AS withCryptaID,
        COUNT(*) OVER w AS fp_size
    FROM $ids
    WINDOW w AS (
        PARTITION BY fp
    )
);

$ids = (
    SELECT
        *
    FROM $ids
    WHERE fp_size < $max_fp_size
);

$pairs = (
    SELECT
        first.id AS id1,
        second.id AS id2,
        first.id_type AS id1Type,
        second.id_type AS id2Type,
        first.fp AS fp,
        (first.idfa == second.idfa AND first.withIdfa) AS trueIdfa,
        (first.withIdfa AND second.withIdfa) AS withIdfa,
        first.idfa AS idfa1,
        second.idfa AS idfa2,
        (first.CryptaID == second.CryptaID AND first.withCryptaID) AS trueCryptaID,
        (first.withCryptaID AND second.withCryptaID) AS withCryptaID,
        first.CryptaID AS cryptaId1,
        second.CryptaID AS cryptaId2,
    FROM $ids AS first
    INNER JOIN $ids AS second
    USING (fp)
    WHERE first.id < second.id
);


$distinct_pairs = (
    SELECT
        id1, id2, id1Type, id2Type,
        MAX(trueIdfa) AS trueIdfa,
        MAX(withIdfa) AS withIdfa,
        MAX(trueCryptaID) AS trueCryptaID,
        MAX(withCryptaID) AS withCryptaID,
        MAX_BY(fp, AsTuple(trueIdfa, fp)) AS fp,
        MAX_BY(idfa1, AsTuple(trueIdfa, idfa1)) AS idfa1,
        MAX_BY(idfa2, AsTuple(trueIdfa, idfa2)) AS idfa2,
        MAX_BY(cryptaId1, AsTuple(trueCryptaID, cryptaId1)) AS cryptaId1,
        MAX_BY(cryptaId2, AsTuple(trueCryptaID, cryptaId2)) AS cryptaId2,
    FROM $pairs
    GROUP BY (id1, id2, id1Type, id2Type)
);

$statsWithIdfa = (
    SELECT
        "with_idfa" AS StatsType,
        (COUNT_IF(trueIdfa) + 0.) / COUNT(*) AS `PrecisionByIDFA`,
        COUNT_IF(trueIdfa) AS TrueIDFACount,

        1.*COUNT_IF(trueCryptaID) / COUNT_IF(withCryptaID) AS `PrecisionByCryptaID`,
        COUNT_IF(trueCryptaID) AS TrueCryptaIDCount,
        COUNT_IF(withCryptaID) AS WithCryptaIDCount,
        COUNT(*) AS `TotalCount`
    FROM $distinct_pairs
    WHERE withIdfa
);

$statsWithoutIdfa = (
    SELECT
        "without_idfa" AS StatsType,

        1.*COUNT_IF(trueCryptaID) / COUNT_IF(withCryptaID) AS `PrecisionByCryptaID`,
        COUNT_IF(trueCryptaID) AS TrueCryptaIDCount,
        COUNT_IF(withCryptaID) AS WithCryptaIDCount,
        COUNT(*) AS `TotalCount`
    FROM $distinct_pairs
    WHERE NOT withIdfa
);

$stats =
    SELECT * FROM $statsWithIdfa
    UNION ALL
    SELECT * FROM $statsWithoutIdfa
;

SELECT
    *
FROM $stats;

INSERT INTO $output_stats WITH TRUNCATE
    SELECT * FROM $stats
;

INSERT INTO $output_pairs WITH TRUNCATE
SELECT
    id1, id2, id1Type, id2Type, fp,
    trueIdfa, withIdfa,
    idfa1, idfa2,
    trueCryptaID, withCryptaID,
    cryptaId1, cryptaId2,
    $timestamp AS firstTimestamp,
    $timestamp AS lastTimestamp,
    1 AS cnt,
    AsDict(AsTuple($fp_type, 1)) AS fpTypes,
    $fp_type AS lastFpType
FROM $distinct_pairs;

