$ids = '{{ input_path }}';
$output_stats = '{{ output_stats }}';

$ids = (
  SELECT
    *
  FROM $ids
  WHERE idfa IS NOT NULL AND idfa != "00000000-0000-0000-0000-000000000000"
);

$idfa_stats = (
    SELECT
        idfa,
        COUNT( DISTINCT fp) AS cnt,
        COUNT(*) AS totalCount,
        SOME(fp) AS someFP,
        COUNT(DISTINCT id) AS id_cnt,
    FROM $ids
    GROUP BY idfa
);

$fp_stats = (
    SELECT
        fp,
        Count(DISTINCT idfa) AS cnt,
        COUNT(*) AS totalCount,
        SOME(idfa) AS someIdfa,
        COUNT(DISTINCT id) AS id_cnt,
    FROM $ids
    GROUP BY fp
);

$fp_idfa_stats = (
    SELECT
        fp, idfa,
        COUNT(DISTINCT id) AS id_cnt
    FROM
    $ids
    GROUP BY (fp, idfa)
);

$fp_idfa_pairs_cnt = SELECT SUM(id_cnt * (id_cnt - 1) / 2) FROM $fp_idfa_stats;
$idfa_pairs_cnt = SELECT SUM(id_cnt * (id_cnt - 1) / 2) FROM $idfa_stats;
$fp_pairs_cnt = SELECT SUM(id_cnt * (id_cnt - 1) / 2) FROM $fp_stats;


INSERT INTO $output_stats WITH TRUNCATE
SELECT
    $fp_idfa_pairs_cnt AS fp_idfa_pairs_cnt,
    $idfa_pairs_cnt AS idfa_pairs_cnt,
    $fp_pairs_cnt AS fp_pairs_cnt,

    ($fp_idfa_pairs_cnt + 0.) / $fp_pairs_cnt AS `Precision`,
    ($fp_idfa_pairs_cnt + 0.) / $idfa_pairs_cnt AS `Recall`;
