$all_pairs = '{{ all_pairs }}';
$output_soup_edges = '{{ output_soup_edges }}';
$soup_weight = {{ soup_weight }};

$ssp_user_id_type_name = IdType::SSP_USER_ID();

$mm_device_id_type_name = IdType::MM_DEVICE_ID();


$soup_edges =
    SELECT
        AsList() AS dates,
        Identifiers::NormalizeSspUserId(CAST(sspid AS String) || "@" || id1) AS id1,
        $ssp_user_id_type_name AS id1Type,
        id2,
        $mm_device_id_type_name AS id2Type,
        LogSource::FINGERPRINT() AS logSource,
        "ssp-app-metrica-ios" AS sourceType,
        IF(trueIdfa, MAX_OF(0.7, $soup_weight), $soup_weight) AS survivalWeight,

    FROM $all_pairs
    WHERE
        (isGood OR trueIdfa)
        AND id1Type == $ssp_user_id_type_name
        AND id2Type == $mm_device_id_type_name
;

$soup_edges =
    SELECT
        id1, id2, id1Type, id2Type, logSource, sourceType,
        SOME(survivalWeight) AS survivalWeight,
        SOME(dates) AS dates,
    FROM $soup_edges
    GROUP BY (id1, id2, id1Type, id2Type, logSource, sourceType)
;

INSERT INTO $output_soup_edges WITH TRUNCATE
    SELECT
        *
    FROM
        $soup_edges
    WHERE
        id1 IS NOT NULL
        AND id2 IS NOT NULL
;
