from crypta.graph.fpc.lib.tasks import ( # noqa
    BuildFingerprints,
    DuidsBySource,
    GetFpcFromAdstat,
    GetFpcFromCheventLog,
    GetFpcFromMts,
    GetFpcFromWatchLog,
    GetFpcViaCookieSync,
    GetFpcViaExtfp,
    GetFpcViaFingerprint,
    GetFpcViaMarket,
    GetFpcViaMcPort,
    GetFpcViaSerp,
    GetFpcViaTls,
    GetFpcViaYclid,
    GetFpcViaZen,
    Hourly,
    UpdateKeyboardUuids,
)
from crypta.lib.python.zk import (
    fake_zk_client,
)
from crypta.lib.python.bt.workflow import (
    execute_sync,
)
import crypta.graph.fpc.proto.config_pb2 as config
from crypta.lib.python.getoptpb import ParsePbOptions
import library.python.resource as rs

import crypta.lib.python.bt.conf.conf as conf
import crypta.lib.python.bt.conf.resource_conf as resource_conf


def execute(task):
    with fake_zk_client() as fake_zk:
        execute_sync(task, fake_zk, do_fork=False)


def toCamelCase(name):
    return ''.join(word.title() for word in name.split('_'))


def main():
    conf.use(resource_conf.find('/crypta/graph/fpc'))

    proto_config = ParsePbOptions(config.TCryptaFpcConfig)
    conf.use_proto(proto_config, defaults=rs.find(proto_config.DefaultsPath))

    taskName = conf.proto.WhichOneof('Task')

    if taskName.startswith('get_fpc_'):
        return execute(globals().get(toCamelCase(taskName))())
    if taskName == 'build_fingerprints':
        return execute(BuildFingerprints())
    if taskName == 'calculate_sources':
        return execute(DuidsBySource())
    if taskName == 'hourly':
        return execute(Hourly(do_export=conf.proto.hourly.Export))
    if taskName == 'update_keyboard_uuids':
        return execute(UpdateKeyboardUuids())
