{% include 'yql/common.sql' %}
{% include 'yql/lib.sql' %}
{% include 'yql/domain_lib.sql' %}
{% include 'yql/parse_lib.sql' %}

$watchlog_data = (
    SELECT
        Digest::SipHash(0, 0, (Ip::FromString(clientip) || useragent)) as macrouserhash,
        Digest::SipHash(0, 0, (Ip::FromString(clientip6) || useragent)) as macrouserhash6,
        Digest::CityHash(Metrika::ParseBrowserinfo(browserinfo)['fip'] || useragent || clientip6) as fip,
        Digest::SipHash(0, 0, Ip::FromString(clientip6) || useragent || cast(tcpport as String)) as mc_port_fip,
        Digest::CityHash(Metrika::ParseBrowserinfo(browserinfo)['fip'] || useragent || cast(tcpport as String)) as no_ip_fip,
        coalesce(Metrika::ParseBrowserinfo(browserinfo)['cc'], "") as cache,
        Digest::CityHash(url) as urlhash,
        $is_good_domain($cut_domain_from_url(url)) as is_good_domain,
        $is_yandex_domain(Url::GetSignificantDomain(referer)) as is_from_yandex,
        String::StartsWith(clientip6, "::ffff:") as is_ipv4,
        ListLength(String::SplitToList(Metrika::ParseBrowserinfo(browserinfo)['fip'] ?? '', '-')) = 11 as is_new_fp,
        $seen_you(browserinfo) as seen_you,
        domainuserid as fpc,
        if (uniqid = domainuserid, "0", uniqid) as uniqid,
        $generate_hash_from_url_and_bi(url, browserinfo) as hash,
        CAST(unixtime as Int64) as last_seen,
        UserAgent::Parse(useragent).OSVersion as osversion,
        UserAgent::Parse(useragent).OSFamily as osfamily,
        Url::GetHost(Url::Normalize(url)) as original_domain,
        $cut_domain_from_url(url) as domain,
        UserAgent::Parse(useragent).BrowserName as browser_name,
        UserAgent::Parse(useragent).BrowserVersion as browser_version,
        cast(watchid as Uint64) as watchid,
        $not_private_relay(clientip6) as not_private_relay
    FROM
        CONCAT({{input_tables}})
    WHERE
        $is_good_useragent(useragent)
        and $is_valid_domain($cut_domain_from_url(url))
        and $cut_domain_from_url(url) != "wi-fi.ru"
        and counterid ?? '0' not in ('3', '48547472')
        and Metrika::ParseBrowserinfo(browserinfo)['pv']=='1'
        and $https_match(url)
        and Url::GetSignificantDomain(referer) != Url::GetSignificantDomain(url)
        and Url::GetSignificantDomain(url) != 'yastatic.net'
        and $is_valid_fpc(domainuserid)
        and $not_upload_or_changed(browserinfo) = true
        and $not_gdpr(regionid)
);

insert into `{{output_table}}` with truncate select * from $watchlog_data;
