$cut_domain = ($domain) -> {
    $punicode = Url::HostNameToPunycode($domain);
    -- because https://a.yandex-team.ru/arc/trunk/arcadia/yabs/server/libs/server/args.cpp?rev=5035683#L2731-2744
    -- that's why
    RETURN (
        CASE
            WHEN Url::GetDomain($punicode, 2) IS NULL THEN Url::GetDomain($punicode, 1)
            WHEN Url::GetDomain($punicode, 2) == 'com.tr' THEN Url::GetDomain($punicode, 3)
            ELSE Url::GetDomain($punicode, 2)
        END
    ) ?? '';
};

$cut_domain_from_url = ($url) -> {
    RETURN $cut_domain(Url::GetHost(Url::Normalize($url)));
};

$is_valid_domain_re = Re2::Match(@@^[a-zA-Z0-9\-\._]+\.[a-zA-Z0-9\-]{2,}$@@);

$is_valid_domain = ($domain) -> {
    RETURN $is_valid_domain_re(Url::HostNameToPunycode($domain));
};
