PRAGMA yt.InferSchema;
PRAGMA yt.QueryCacheMode = "normal";
PRAGMA SimpleColumns;

{% include 'yql/lib.sql' %}

$generate_yuid = ($seed) -> {
    $ts = CAST(YQL::Now() AS String);
    $id = Digest::MurMurHash($seed);
    $id = SUBSTRING(YQL::ToString($id), 0, 9);

    $retval = $id || SUBSTRING($ts, 0, 10);

    $to_add = case
        when
            length($id) < 8
        then
            CAST(Math::Pow(10, 8 - length($id)) - 1 as String)
        else
            ""
    end;

    $retval = $to_add || $retval;
    return $retval;
};

$generate_if_null = ($hash, $yuid) -> {
    return case
        when $yuid is null
        then $generate_yuid($hash)
        else
             $yuid
        end;
};

$joined_comps = (
    select
           coalesce(g.u, d.domain_cookie) as group_id,
           coalesce(g.v, d.domain_cookie) as fpc,
           $generate_if_null(g.u, d.yuid) as yuid,
           d.yuid is null as yuid_generated,
           g.v as v,
           d.domain as domain,
           d.original_domain as original_domain,
           d.domain_cookie as domain_cookie,
    from `{{ input_table }}` as d
    full join `{{ uvgraph_table }}` as g
    on (d.domain_cookie == g.v)
);

$merged_comps = (
    select
        group_id,
        row_number() over w as rn,
        fpc,
        min($extract_ts(yuid)) over w as ts,
        min_by(yuid, $extract_ts(yuid)) over w as yuid,
        min(yuid_generated) over w as yuid_generated,
        v,
        domain,
        domain_cookie,
        original_domain,
    from $joined_comps
    window w as (partition by group_id order by $extract_ts(yuid))
);

insert into `{{ output_table }}` with truncate
select
    yuid,
    fpc as duid,
    group_id,
    rn,
    ts,
    yuid_generated,
    v,
    domain,
    original_domain,
    domain_cookie,
from $merged_comps
where yuid_generated = false;
