{% include 'yql/common.sql' %}
{% include 'yql/lib.sql' %}
{% include 'yql/domain_lib.sql' %}
{% include 'yql/parse_lib.sql' %}

$mts_data = (
    select
        clientip6,
        uniqid,
        useragent,
        browserinfo,
        domainuserid,
        url,
        regionid,
        counterid,
        referer,
        cast(unixtime as int64) as unixtime
    from
        concat({{ input_tables }})
    where
        not String::StartsWith(clientip6, "::ffff:")
        and Geo::GetIspNameByIp(clientip6) in ('mts pjsc')
);

$mts_with_yuid = (
    select
        Digest::CityHash(clientip6 || useragent) as hash,
        unixtime,
        uniqid,
    from
        $mts_data
    where
        $https_match(url)
        and $is_good_useragent(useragent)
        and $is_valid_domain($cut_domain_from_url(url))
        and $not_upload_or_changed(browserinfo) = true
        and Metrika::ParseBrowserinfo(browserinfo)['pv']=='1'
        and $not_gdpr(regionid)
        and counterid ?? '0' not in ('3', '48547472')
        and Url::GetSignificantDomain(referer) != Url::GetSignificantDomain(url)
        and Url::GetSignificantDomain(url) != 'yastatic.net'
        and $is_valid_yuid(uniqid)
        and uniqid != domainuserid
);

$mts_with_duid = (
    select
        Digest::CityHash(clientip6 || useragent) as hash,
        unixtime,
        useragent,
        domainuserid as domain_cookie,
        url
    from
        $mts_data
    where
        $https_match(url)
        and $is_good_useragent(useragent)
        and $is_good_domain($cut_domain_from_url(url))
        and $not_upload_or_changed(browserinfo) = true
        and Metrika::ParseBrowserinfo(browserinfo)['pv']=='1'
        and $not_gdpr(regionid)
        and counterid ?? '0' not in ('3', '48547472')
        and Url::GetSignificantDomain(referer) != Url::GetSignificantDomain(url)
        and $is_valid_fpc(domainuserid)
);

$joined_data = (
    select
        left.uniqid as yuid,
        max_of(left.unixtime, right.unixtime) as last_seen,
        right.url as url,
        right.useragent as useragent,
        right.domain_cookie as domain_cookie
    from
        $mts_with_yuid as left
    inner join
        $mts_with_duid as right
    using (hash)
    where
        abs(left.unixtime - right.unixtime) < 300
);

insert into
    `{{ output_table }}` with truncate
select
    min_by(yuid, $extract_ts(yuid)) as yuid,
    max(last_seen) as last_seen,
    domain_cookie,
    some(UserAgent::Parse(useragent).OSVersion) as osversion,
    some(UserAgent::Parse(useragent).OSFamily) as osfamily,
    some(Url::GetHost(Url::Normalize(url))) as original_domain,
    some($cut_domain_from_url(url)) as domain,
    some(UserAgent::Parse(useragent).BrowserName) as browser_name,
    some(UserAgent::Parse(useragent).BrowserVersion) as browser_version,
    "mts" as source,
    false as seen_you
from
    $joined_data
group by
    domain_cookie;
