{% include 'yql/common.sql' %}
{% include 'yql/lib.sql' %}
{% include 'yql/domain_lib.sql' %}
{% include 'yql/parse_lib.sql' %}

insert into `{{output_table}}` with truncate
select
    UserAgent::Parse(useragent).OSVersion AS osversion,
    UserAgent::Parse(useragent).OSFamily AS osfamily,
    UserAgent::Parse(useragent).BrowserName as browser_name,
    UserAgent::Parse(useragent).BrowserVersion as browser_version,
    uniqid AS yuid,
    Url::GetHost(Url::Normalize(url)) AS original_domain,
    $cut_domain_from_url(url) AS domain,
    $get_domain_cookie(browserinfo) AS domain_cookie,
    CAST(unixtime AS Int64) AS last_seen,
    $generate_hash_from_url_and_bi(url, browserinfo) AS hash,
    $seen_you(browserinfo) as seen_you,
    "watch" AS source
from CONCAT({{ input_tables }})
where
    $is_good_useragent(useragent) and
    $is_valid_yuid(uniqid) and
    uniqid != domainuserid and
    $is_good_domain($cut_domain_from_url(url)) and
    $is_valid_fpc($get_domain_cookie(browserinfo)) and
    $not_upload_or_changed(browserinfo) = true and
    $not_gdpr(regionid) and
    not $seen_you(browserinfo);
