{% include 'yql/common.sql' %}
{% include 'yql/lib.sql' %}
{% include 'yql/domain_lib.sql' %}
{% include 'yql/parse_lib.sql' %}

$is_yandex_counter = ($counterid) -> {
    RETURN $counterid ?? '0' = '722545';
};

$extract_synced_duid = ($browserinfo) -> {
    RETURN COALESCE(Metrika::ParseBrowserinfo($browserinfo)['pi'], '0')
};

$extract_synced_domain = ($browserinfo) -> {
    RETURN $cut_domain(
        COALESCE(
            String::Base64Decode(Metrika::ParseBrowserinfo($browserinfo)['pid']),
            'auto.ru'
        )
    ); -- auto.ru was the first one so it's the default
};

$is_in_experiment = ($domain_cookie, $domain) -> {
    RETURN (Digest::MurMurHash($domain_cookie || "rfpcm" || $domain) % 2) == 0;
};

$cookie_sync_data = (
    SELECT
        UserAgent::Parse(useragent).OSVersion AS osversion,
        UserAgent::Parse(useragent).OSFamily AS osfamily,
        UserAgent::Parse(useragent).BrowserName as browser_name,
        UserAgent::Parse(useragent).BrowserVersion as browser_version,
        uniqid AS yuid,
        $extract_synced_domain(browserinfo) AS original_domain,
        $cut_domain($extract_synced_domain(browserinfo)) AS domain,
        $extract_synced_duid(browserinfo) AS domain_cookie,
        CAST(unixtime AS Int64) AS last_seen,
    FROM
        CONCAT({{ input_tables }})
    WHERE
        $is_good_useragent(useragent) AND
        $is_valid_yuid(uniqid) AND
        uniqid != domainuserid AND
        $is_yandex_counter(counterid) AND
        $not_upload_or_changed(browserinfo) = true AND
        $not_gdpr(regionid)
);

INSERT INTO `{{output_table}}`
WITH TRUNCATE
SELECT
    last_seen,
    original_domain,
    domain,
    domain_cookie,
    yuid,
    osversion,
    osfamily,
    browser_name,
    browser_version,
    $generate_hash(original_domain || domain_cookie) AS hash,
    'cookie_sync' AS source,
    false as seen_you
FROM
    $cookie_sync_data
WHERE
    $is_valid_fpc(domain_cookie) AND
    $is_in_experiment(domain_cookie, original_domain);
