{% include 'yql/common.sql' %}
{% include 'yql/lib.sql' %}
{% include 'yql/domain_lib.sql' %}
{% include 'yql/parse_lib.sql' %}

{% if not is_embedded %}
PRAGMA File('libextfp_exp_udf.so', 'yt://hahn/home/crypta/public/udfs/unstable/libextfp_exp_udf.so');
PRAGMA Udf('libextfp_exp_udf.so');
{% endif %}

$max_duids_in_comp = 100;
$default_salt = "extfp";
$extfp_prefix = "ext-fp-";

$banned_sources = AsList();
$experiment_sources = AsList("beeline", "mts");

$experiment_should_upload = ($salt, $s, $source) -> {
    return case
        when $source not in $experiment_sources then true
        else ExtfpExperiment::ShouldUpload($s)
    end;
};

$is_valid_yuid_extended = ($yuid, $duid) -> {
    return if ($is_valid_yuid($yuid),
        if ($yuid = $duid, null, $yuid),
        null);
};

$candidates = (
    select
        aggregate_list_distinct(
                $is_valid_yuid_extended(cast(yuid as String), cast(duid as String)),
                $max_list_values) as uniqids,
        aggregate_list_distinct(
            if ($is_good_domain(original_domain),
                ($cut_domain(original_domain), cast(duid as String)),
                null),
                $max_list_values) as duids,
        max(unixtime) as last_seen,
        user_agent as useragent,
        some(ext_source) as ext_source
    from
        concat({{input_tables}})
    where
        $is_good_useragent(user_agent)
        and ext_source not in $banned_sources
    group by
        ext_source, ext_id, user_agent
);

$yuid_duids = (
    select
        $bestYandexuidByTs(uniqids) as yuid,
        $extfp_prefix || ext_source as source,
        ext_source as ext_source,
        DictItems(ToDict(duids)) as duids,
        last_seen as last_seen,
        UserAgent::Parse(useragent).OSVersion AS osversion,
        UserAgent::Parse(useragent).OSFamily AS osfamily,
        UserAgent::Parse(useragent).BrowserName as browser_name,
        UserAgent::Parse(useragent).BrowserVersion as browser_version,
    from
        $candidates
    where
        $bestYandexuidByTs(uniqids) is not null
        and $is_good_list_length(duids, 1, $max_duids_in_comp)
);

insert into `{{output_table}}`
select
    yuid, source, last_seen, osfamily, osversion, browser_name, browser_version,
    duids.0 as domain, duids.0 as original_domain, duids.1 as domain_cookie,
    false as seen_you
from $yuid_duids
    flatten list by duids
where
    $is_good_domain(duids.0)
    and $experiment_should_upload($default_salt, yuid, ext_source)
{% if is_embedded %}
order by domain_cookie
{% endif %}
;

insert into `{{extfp_extra_ab_table}}`
select
    yuid, source, last_seen, osfamily, osversion, browser_name, browser_version,
    duids.0 as domain, duids.0 as original_domain, duids.1 as domain_cookie,
    CurrentUtcTimestamp() as utc_mine_time, $experiment_should_upload($default_salt, yuid, ext_source) as should_upload
from $yuid_duids
    flatten list by duids
where
    $is_good_domain(duids.0)
    and ext_source in $experiment_sources
;
