{% include 'yql/common.sql' %}
{% include 'yql/lib.sql' %}
{% include 'yql/domain_lib.sql' %}
{% include 'yql/parse_lib.sql' %}

$candidates_fip = (
SELECT
    AGGREGATE_LIST_DISTINCT(
        IF ($is_valid_yuid(uniqid) and not seen_you,
            uniqid,
            null),
            $max_list_values) as uniqids,
    AGGREGATE_LIST_DISTINCT(
        IF (is_good_domain,
            (domain, fpc),
            null),
            $max_list_values) as duids,
    max(last_seen) as last_seen,
    "fip" as source,
    SOME(browser_name) as browser_name,
    SOME(browser_version) as browser_version,
    SOME(osfamily) as osfamily,
    SOME(osversion) as osversion,
FROM
    CONCAT({{input_tables}})
WHERE
    is_new_fp == true
    and not_private_relay
GROUP BY
    fip
);

$candidates_cache = (
SELECT
    AGGREGATE_LIST_DISTINCT(
        IF ($is_valid_yuid(uniqid) and not seen_you,
            uniqid,
            null),
            $max_list_values) as uniqids,
    AGGREGATE_LIST_DISTINCT(
        IF (is_good_domain,
            (domain, fpc),
            null),
            $max_list_values) as duids,
    max(last_seen) as last_seen,
    "cache" as source,
    SOME(browser_name) as browser_name,
    SOME(browser_version) as browser_version,
    SOME(osfamily) as osfamily,
    SOME(osversion) as osversion,
FROM
    CONCAT({{input_tables}})
where
    not_private_relay
GROUP BY
    Digest::SipHash(0, 0, cache || cast(urlhash as String) || cast(macrouserhash6 as String)) as fip
);

$candidates = (select
    * from $candidates_fip
    union all select
    * from $candidates_cache
);

$yuid_duids = (
    select
        $bestYandexuidByTs(uniqids) as yuid,
        DictItems(ToDict(duids)) as duids,
        source,
        last_seen as last_seen,
        osfamily,
        osversion,
        browser_name,
        browser_version
    from
        $candidates
    where
        $bestYandexuidByTs(uniqids) is not null
        and $is_good_list_length(duids, 1, 100)
);

$no_ip_fip_data = (
    select
        a.uniqid as yuid,
        b.fpc as duid,
        b.domain as domain,
        b.browser_name as browser_name,
        b.browser_version as browser_version,
        b.osfamily as osfamily,
        b.osversion as osversion,
        a.last_seen as last_seen,
    from
        CONCAT({{input_tables}}) as a
    inner join
        CONCAT({{input_tables}}) as b
    using
        (no_ip_fip)
    where
        a.watchid != b.watchid
        and $is_valid_yuid(a.uniqid)
        and $is_valid_fpc(b.fpc)
        and $is_yandex_domain(a.domain)
        and not a.seen_you
        and $is_good_domain(b.domain)
        and a.is_new_fp == true
        and abs(a.last_seen-b.last_seen) <= 300
);

$no_ip_fip_data_grouped = (
    select
        min_by(yuid, $extract_ts(yuid)) as yuid,
        domain_cookie,
        some(domain) as domain,
        some(domain) as original_domain,
        some(browser_name) as browser_name,
        some(browser_version) as browser_version,
        some(osfamily) as osfamily,
        some(osversion) as osversion,
        max(last_seen) as last_seen,
        "noipfip" as source,
        false as seen_you
    from
        $no_ip_fip_data
    group by
        duid as domain_cookie
);

$fresh_data = (
    select
        yuid, source, last_seen, osfamily, osversion, browser_name, browser_version,
        duids.0 as domain, duids.0 as original_domain, duids.1 as domain_cookie,
        false as seen_you
    from $yuid_duids
        flatten list by duids
    where
        $is_good_domain(duids.0)
    {% if is_embedded %}
    order by domain_cookie
    {% endif %}
);

insert into `{{output_table}}`
select * from (
    select * from $fresh_data
    union all
    select * from $no_ip_fip_data_grouped
);
